//	Critical Mass Be
//	13/7/97
//	Hamish Carr
//
//	CMassWindow.cpp

#include "CMassWindow.h"

CMassWindow::CMassWindow(BRect frame)
				: BWindow(frame, "Critical Mass", B_TITLED_WINDOW, B_NOT_RESIZABLE)
{
BMenu			*aMenu;												//	used for adding menu items
BRect			aRect;												//	used for setting sizes
BMenuItem		*theMenuItem;										//	used for creating menu items

aRect.Set(0, 20, 383, 370);											//	set to a suitable size for the board
theView = new CMassView(aRect, "Critical Mass View");				//	initialize the board view
AddChild(theView);													//	add the view as a child to this window

aRect.Set(0, 0, 383, 20);											//	set the size of the menu bar
theMenuBar = new BMenuBar(aRect, "Critical Mass Menu Bar");			//	initialize the menu bar

//	Game menu
aMenu = new BMenu("Game", B_ITEMS_IN_COLUMN);						//	initialize a menu
theMenuItem = new BMenuItem("About Critical Mass", new BMessage(AboutCMItem), 'A', NULL);
aMenu->AddItem(theMenuItem);
aMenu->AddSeparatorItem();											//	add a separator
theMenuItem = new BMenuItem("New Game", new BMessage(NewGameItem), 'N', NULL);
aMenu->AddItem(theMenuItem);
//theMenuItem = new BMenuItem("Take Back Move", new BMessage(TakeBackItem), 'T', NULL);
//theMenuItem->SetEnabled(false);										//	mark it not yet available
//aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Quit", new BMessage(QuitItem), 'Q', NULL);
aMenu->AddItem(theMenuItem);
theMenuBar->AddItem(aMenu);											//	add this menu to the menu bar

//	Player 1 menu
aMenu = new BMenu("Red", B_ITEMS_IN_COLUMN);						//	initialize a menu
theMenuItem = new BMenuItem("Human", new BMessage(Player1HumanItem), NULL, NULL);
theMenuItem->SetMarked(true);
aMenu->AddItem(theMenuItem);
aMenu->AddSeparatorItem();											//	add a separator
theMenuItem = new BMenuItem("Random", new BMessage(Player1RandomItem), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Smart", new BMessage(Player1SmartItem), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("A.I.", new BMessage(Player1AIItem), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Bill Kocay", new BMessage(Player1IsBillKocayItem), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuBar->AddItem(aMenu);											//	add this menu to the menu bar

//	Player 2 menu
aMenu = new BMenu("Blue", B_ITEMS_IN_COLUMN);					//	initialize a menu
theMenuItem = new BMenuItem("Human", new BMessage(Player2HumanItem), NULL, NULL);
aMenu->AddItem(theMenuItem);
aMenu->AddSeparatorItem();											//	add a separator
theMenuItem = new BMenuItem("Random", new BMessage(Player2RandomItem), NULL, NULL);
theMenuItem->SetMarked(true);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Smart", new BMessage(Player2SmartItem), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("A.I.", new BMessage(Player2AIItem), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Bill Kocay", new BMessage(Player2IsBillKocayItem), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuBar->AddItem(aMenu);											//	add this menu to the menu bar

//	Options menu
aMenu = new BMenu("Options", B_ITEMS_IN_COLUMN);					//	initialize a menu
theMenuItem = new BMenuItem("Sound", new BMessage(OptionSoundToggleItem), 'S', NULL);
//theMenuItem->SetEnabled(false);
theMenuItem->SetMarked(true);
aMenu->AddItem(theMenuItem);
aMenu->AddSeparatorItem();											//	add a separator
theMenuItem = new BMenuItem("Fast Display", new BMessage(OptionFastDisplayItem), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Medium Display", new BMessage(OptionMediumDisplayItem), NULL, NULL);
theMenuItem->SetMarked(true);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Slow Display", new BMessage(OptionSlowDisplayItem), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuBar->AddItem(aMenu);											//	add this menu to the menu bar

//	Thought Speed menu
aMenu = new BMenu("Priority", B_ITEMS_IN_COLUMN);				//	initialize a menu
theMenuItem = new BMenuItem("Low Priority", new BMessage(B_LOW_PRIORITY), NULL, NULL);
theMenuItem->SetMarked(true);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Normal Priority", new BMessage(B_NORMAL_PRIORITY), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Display Priority", new BMessage(B_DISPLAY_PRIORITY), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Urgent Display Priority", new BMessage(B_URGENT_DISPLAY_PRIORITY), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Real Time Display Priority", new BMessage(B_REAL_TIME_DISPLAY_PRIORITY), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Urgent Priority", new BMessage(B_URGENT_PRIORITY), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Hog Mode", new BMessage(B_REAL_TIME_PRIORITY), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuBar->AddItem(aMenu);											//	add this menu to the menu bar

//	Help menu
aMenu = new BMenu("Help", B_ITEMS_IN_COLUMN);						//	initialize a menu
theMenuItem = new BMenuItem("About Critical Mass", new BMessage(AboutCMItem), 'A', NULL);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Game Rules", new BMessage(HelpGameRulesItem), 'H', NULL);
aMenu->AddItem(theMenuItem);
theMenuItem = new BMenuItem("Game Menus", new BMessage(HelpMenuOptionsItem), NULL, NULL);
aMenu->AddItem(theMenuItem);
theMenuBar->AddItem(aMenu);											//	add this menu to the menu bar

AddChild(theMenuBar);												//	add the menu to the window
theMenuBar->AttachedToWindow();										//	and tell it that it is attached
SetPulseRate(100000);												//	ask for pulses every 0.1 s						
}

bool CMassWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
}

void CMassWindow::MessageReceived(BMessage *theEvent)				//	responds to event messages
																	//	by forwarding them to the view
	{
	BMenuItem *theItem;												//	used for marking menu items
	switch (theEvent->what)											//	just a big switch statement
		{
		// 	items on Game menu
		case AboutCMItem: 
			ShowAlert(AboutCMItem);									//	call the ShowAlert routine
			break;						
		case NewGameItem:
			theView->NewGame();										//	start a new game 
			theView->Invalidate();									//	force the view to redraw
			break;
//		case TakeBackItem: 
//			break;
		case QuitItem: 
			QuitRequested(); 
			break;

		//	items on Player 1 Menu
		case Player1HumanItem:
			ResetPlayer(RED_PLAYER, HUMAN_PLAYER);						//	reset the player
			break;
		case Player1RandomItem:
			ResetPlayer(RED_PLAYER, RANDOM_PLAYER);						//	reset the player
			break;
		case Player1SmartItem:
			ResetPlayer(RED_PLAYER, SMART_PLAYER);						//	reset the player
			break;
		case Player1AIItem:
			ResetPlayer(RED_PLAYER, AI_PLAYER);							//	reset the player
			break;
		case Player1IsBillKocayItem:
			ResetPlayer(RED_PLAYER, BILL_KOCAY_PLAYER);					//	reset the player
			break;

		//	items on Player 2 Menu
		case Player2HumanItem:
			ResetPlayer(BLUE_PLAYER, HUMAN_PLAYER);						//	reset the player
			break;
		case Player2RandomItem:
			ResetPlayer(BLUE_PLAYER, RANDOM_PLAYER);					//	reset the player
			break;
		case Player2SmartItem:
			ResetPlayer(BLUE_PLAYER, SMART_PLAYER);						//	reset the player
			break;
		case Player2AIItem:
			ResetPlayer(BLUE_PLAYER, AI_PLAYER);						//	reset the player
			break;
		case Player2IsBillKocayItem:
			ResetPlayer(BLUE_PLAYER, BILL_KOCAY_PLAYER);				//	reset the player
			break;

		//	items on Options Menu
		case OptionSoundToggleItem:										//	change sound
			theItem = theMenuBar->FindItem(OptionSoundToggleItem);		//	find it on the menu
			theItem->SetMarked(!theItem->IsMarked());					//	invert the mark
			theView->ToggleSound();										//	toggle it
			break;
		case OptionFastDisplayItem:										//	change speed
		case OptionMediumDisplayItem:									//	change speed
		case OptionSlowDisplayItem:										//	change speed
			ResetSpeed(theEvent->what);									//	using the message value
			break;

		//	items on Thought Speed Menu
		case B_LOW_PRIORITY:											//	set the thought priority
		case B_NORMAL_PRIORITY:									
		case B_DISPLAY_PRIORITY:
		case B_URGENT_DISPLAY_PRIORITY:
		case B_REAL_TIME_DISPLAY_PRIORITY:
		case B_URGENT_PRIORITY:
		case B_REAL_TIME_PRIORITY:
			ResetPriority(theEvent->what);
			break;
		//	items on Help Menu
		case HelpGameRulesItem:
			ShowAlert(HelpGameRulesItem);								//	call the ShowAlert routine
		case HelpMenuOptionsItem:
			ShowAlert(HelpMenuOptionsItem);								//	call the ShowAlert routine
			break;

		} // end of switch on theEvent->what
	} // end of MessageReceived
	
void CMassWindow::ResetPlayer(int player, int playerType)				//	resets the player type
	{
	BMenuItem *theItem;													//	and to the relevant item
	long theID;															//	for calculating item ID

	if (player == RED_PLAYER)											//	first player
		{
		theID = Player1HumanItem+theView->redPlayerType;
		theItem = theMenuBar->FindItem(theID);							// 	retrieve the currently marked item
		theItem->SetMarked(false);										//	unmark it
		theID = Player1HumanItem+playerType;
		theItem = theMenuBar->FindItem(theID);							//	get the new item
		theItem->SetMarked(true);										//	unmark it
		} // end of red player case
	else
		{
		theID = Player2HumanItem+theView->bluePlayerType;
		theItem = theMenuBar->FindItem(theID);							// 	retrieve the currently marked item
		theItem->SetMarked(false);										//	unmark it
		theID = Player2HumanItem+playerType;
		theItem = theMenuBar->FindItem(theID);							//	get the new item
		theItem->SetMarked(true);										//	unmark it
		} // end of blue player case
	theView->SetPlayerType(player, playerType);							//	and call CMassView to reset type
	} // end of ResetPlayer()
	
void CMassWindow::ResetSpeed(long speedOption)							//	resets the speed
	{
	BMenuItem *theItem;													//	for retrieving items
	theItem = theMenuBar->FindItem(theView->speedID);					//	retrieve the item
	theItem->SetMarked(false);											//	unmark it
	theView->SetDisplaySpeed(speedOption);								//	set the new speed
	theItem = theMenuBar->FindItem(speedOption);						//	retrieve the item
	theItem->SetMarked(true);											//	mark it
	} // end of ResetSpeed()

void CMassWindow::ResetPriority(long newPriority)						//	resets the priority
	{
	BAlert *alert;														//	the alert that we will use
	long result;														//	to retrieve the result

	if ((newPriority > thoughtPriority)	&& (newPriority > B_URGENT_DISPLAY_PRIORITY))
		{
		alert = new BAlert("Processor Hogging", "Are you sure that you want to give the brain such a disgustingly high priority?\n\nThis will seriously screw up other applications", "Yes", "No", NULL, B_WIDTH_AS_USUAL);
		BRect windowRect = Frame();										//	find the screen coords of the window
		BRect alertRect = alert->Frame();								//	find the frame for the alert
		alertRect.left = windowRect.left + ((windowRect.right - windowRect.left) - (alertRect.right - alertRect.left))/2;
		alertRect.top = windowRect.top + ((windowRect.bottom - windowRect.top) - (alertRect.bottom - alertRect.top))/2;
																		//	centre the alert in the view
		alert->MoveTo(alertRect.left, alertRect.top);					//	move the alert correspondingly
		result = alert->Go();											//	run the alert box
		if (result == 1) return;
		} // end of test for ugly priorities								
	
	
	BMenuItem *theItem;													//	for retrieving items
	theItem = theMenuBar->FindItem(thoughtPriority);					//	retrieve the item
	theItem->SetMarked(false);											//	unmark it
	theItem = theMenuBar->FindItem(newPriority);						//	retrieve the item
	theItem->SetMarked(true);											//	mark it
	thoughtPriority = newPriority;										//	set new priority
	} // end of ResetPriority()
	
void CMassWindow::ShowAlert(long whichItem)								//	shows an alert for rules, &c.
	{
	BAlert *alert;														//	the alert that we will use
	long whichAlert;													//	which box to put up
	long result;														//	to retrieve the result

	switch(whichItem)													//	convert to 0..3 index
		{
		case AboutCMItem:	
			whichAlert = 0; 
			break;
		case HelpGameRulesItem:
			whichAlert = 1;
			break;
		case HelpMenuOptionsItem:
			whichAlert = 2;
			break;
		} // end of switch(whichItem
		
	while (whichAlert != 3)												//	keep going until they hit done
		switch (whichAlert)												//	switch on which alert to put up
			{
			case 0:														//	About box
				alert = new BAlert("About Critical Mass", HELP_STRING, "Rules", "Menus", "Done", B_WIDTH_AS_USUAL);
				result = alert->Go();									//	run the alert box
				whichAlert = result + 1;								//	compensate for not having "about" button
				break;
			case 1:														//	Rules box
				alert = new BAlert("Critical Mass Rules", RULES_STRING, "About", "Menus", "Done", B_WIDTH_AS_USUAL);
				result = alert->Go();									//	run the alert box
				if (result > 0)
					whichAlert = result + 1;							//	compensate for not having "rules" button
				else whichAlert = result;
				break;
			case 2:														//	Menu box
				alert = new BAlert("About Critical Mass", MENU_STRING, "About", "Rules", "Done", B_WIDTH_AS_USUAL);
				result = alert->Go();									//	run the alert box
				if (result > 1)
					whichAlert = result + 1;							//	compensate for not having "menu" button
				else whichAlert = result;
				break;
			} // end of switch(whichItem)
		
	} // end of ShowAlert()